const colors = ["gray", "red", "green", "blue"];
let currentIndex = 0;

// ---- Lecture de la couleur depuis la base ----
function fetchState() {
  fetch("get_state.php")
    .then(r => r.json())
    .then(data => {
      if (data.color) {
        document.getElementById("circle").style.background = data.color;
      }
    })
    .catch(err => console.log("fetchState error", err));
}

// ---- Changement de couleur ----
function changeColor() {
  currentIndex = (currentIndex + 1) % colors.length;
  const newColor = colors[currentIndex];
  
  fetch("set_state.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: "color=" + encodeURIComponent(newColor)
  })
  .then(r => r.json())
  .then(data => {
    if (data.ok) {
      // Met à jour le rond localement
      document.getElementById("circle").style.background = data.color;
    }
  })
  .catch(err => console.log("setState error", err));
}

// ---- Initialisation ----
document.getElementById("btn").addEventListener("click", changeColor);
setInterval(fetchState, 1000); // vérifie toutes les 1s
fetchState(); // première lecture immédiate
