$(document).ready(function() {

    let attaqueChoisie = null;
    let cibleChoisie = null;
    let defenseChoisie = null;

    let bluffAnnonce = null;
    let bluffReel = null;
    let bluffChoix = null;

    setInterval(actualiserEtat, 1000);

    function hideAllActions() {
        $("#actions_attack").hide();
        $("#actions_defense").hide();
        $("#joker_repair").hide();
        $("#actions_bluff_attacker").hide();
        $("#actions_bluff_defender").hide();
    }

    function actualiserEtat() {
        $.ajax({
            url: "game.php",
            type: "POST",
            data: { base: "get" },
            dataType: "json",
            success: function(game) {

                let idJoueur = $("#id_joueur").text();

                $("#game_state").html(`
                    <h3>État du jeu</h3>
                    <p>Phase attaque: ${game.phase}</p>
                    <p>Phase bluff: ${game.phase_bluff ? game.phase_bluff : "aucun"}</p>
                    <p>Tour du joueur : ${game.joueur}</p>

                    <h4>Joueur 1</h4>
                    <p>Vaisseau 1 : ${game.vaisseau1}</p>
                    <p>Pierre 1 : ${game.pierre1}</p>
                    <p>Feuille 1 : ${game.feuille1}</p>
                    <p>Ciseau 1 : ${game.ciseau1}</p>
                    <p>Jokers 1 : ${game.joker1}</p>

                    <h4>Joueur 2</h4>
                    <p>Vaisseau 2 : ${game.vaisseau2}</p>
                    <p>Pierre 2 : ${game.pierre2}</p>
                    <p>Feuille 2 : ${game.feuille2}</p>
                    <p>Ciseau 2 : ${game.ciseau2}</p>
                    <p>Jokers 2 : ${game.joker2}</p>
                `);

                $("#status_msg").text("");
                hideAllActions();

                // Gestion du bluff en priorité
                if (game.phase_bluff && game.phase_bluff === "reponse") {

                    if (idJoueur == game.bluff_joueur) {
                        $("#status_msg").text("Tu as lancé un bluff, en attente de la réponse de l'adversaire.");
                    } else {
                        $("#status_msg").text("Le joueur " + game.bluff_joueur + " annonce qu'il joue : " + game.bluff_annonce);
                        $("#actions_bluff_defender").show();
                    }
                    return;
                }

                // Si pas de bluff en cours, gestion attaque/defense/reparation
                if (game.phase === "attente") {

                    if (idJoueur == game.joueur) {
                        $("#status_msg").text("C'est ton tour. Tu peux attaquer, réparer ou bluffer.");
                        $("#actions_attack").show();
                        $("#joker_repair").show();
                        $("#actions_bluff_attacker").show();
                    } else {
                        $("#status_msg").text("En attente du tour de l'autre joueur.");
                    }

                } else if (game.phase === "defense") {

                    if (idJoueur == game.attaque_joueur) {
                        $("#status_msg").text("Tu as attaqué, en attente de la défense.");
                    } else {
                        $("#status_msg").text("Tu dois te défendre !");
                        $("#actions_defense").show();
                    }
                }
            }
        });
    }

    ////////////////////////////////////////////////////////////
    // ATTAQUE
    ////////////////////////////////////////////////////////////
    $(".attack_btn").click(function() {
        attaqueChoisie = $(this).data("drone");
    });

    $(".target_btn").click(function() {
        cibleChoisie = $(this).data("target");
    });

    $("#confirm_attack").click(function() {
        let idJoueur = $("#id_joueur").text();

        if (!attaqueChoisie || !cibleChoisie) {
            alert("Choisis un drone et une cible.");
            return;
        }

        $.ajax({
            url: "game.php",
            type: "POST",
            dataType: "json",
            data: {
                base: "attack",
                joueur: idJoueur,
                drone: attaqueChoisie,
                cible: cibleChoisie
            },
            success: function(res) {
                console.log("attack", res);
            }
        });
    });

    ////////////////////////////////////////////////////////////
    // DEFENSE
    ////////////////////////////////////////////////////////////
    $(".def_btn").click(function() {
        defenseChoisie = $(this).data("drone");
    });

    $("#confirm_defense").click(function() {

        let idJoueur = $("#id_joueur").text();

        if (!defenseChoisie) {
            alert("Choisis un drone pour te défendre.");
            return;
        }

        $.ajax({
            url: "game.php",
            type: "POST",
            dataType: "json",
            data: {
                base: "defend",
                joueur: idJoueur,
                drone: defenseChoisie
            },
            success: function(res) {
                console.log("defend", res);
            }
        });
    });

    ////////////////////////////////////////////////////////////
    // JOKER REPARATION
    ////////////////////////////////////////////////////////////
    $(".repair_btn").click(function() {
        let drone = $(this).data("drone");
        let idJoueur = $("#id_joueur").text();

        $.ajax({
            url: "game.php",
            type: "POST",
            dataType: "json",
            data: {
                base: "repair",
                joueur: idJoueur,
                drone: drone
            },
            success: function(res) {
                console.log("repair", res);
            }
        });
    });

    ////////////////////////////////////////////////////////////
    // JOKER BLUFF - ATTAQUANT
    ////////////////////////////////////////////////////////////
    $(".bluff_annonce_btn").click(function() {
        bluffAnnonce = $(this).data("drone");
    });

    $(".bluff_reel_btn").click(function() {
        bluffReel = $(this).data("drone");
    });

    $("#confirm_bluff").click(function() {
        let idJoueur = $("#id_joueur").text();

        if (!bluffAnnonce || !bluffReel) {
            alert("Choisis une attaque annoncée et une vraie attaque.");
            return;
        }

        $.ajax({
            url: "game.php",
            type: "POST",
            dataType: "json",
            data: {
                base: "bluff_start",
                joueur: idJoueur,
                annonce: bluffAnnonce,
                reel: bluffReel
            },
            success: function(res) {
                console.log("bluff_start", res);
            }
        });
    });

    ////////////////////////////////////////////////////////////
    // JOKER BLUFF - DEFENSEUR
    ////////////////////////////////////////////////////////////
    $(".bluff_answer_btn").click(function() {
        bluffChoix = $(this).data("choix");
    });

    $("#confirm_bluff_answer").click(function() {
        let idJoueur = $("#id_joueur").text();

        if (!bluffChoix) {
            alert("Choisis si tu le crois ou s'il ment.");
            return;
        }

        $.ajax({
            url: "game.php",
            type: "POST",
            dataType: "json",
            data: {
                base: "bluff_answer",
                joueur: idJoueur,
                choix: bluffChoix
            },
            success: function(res) {
                console.log("bluff_answer", res);
            }
        });
    });

    ////////////////////////////////////////////////////////////
    // RESET
    ////////////////////////////////////////////////////////////
    $("#start_game").click(function() {
        $.ajax({
            url: "game.php",
            type: "POST",
            dataType: "json",
            data: { base: "start" },
            success: function(res) {
                console.log("reset", res);
            }
        });
    });

});
