<?php
header('Content-Type: application/json');
require_once 'config.php';
session_start();

$action = $_POST['action'] ?? '';
if (!isset($_SESSION['username'])) {
    echo json_encode(['success'=>false,'message'=>'Vous devez être connecté']);
    exit;
}
$username = $_SESSION['username'];

function ensure_single_game($conn) {
    $r = $conn->query("SELECT * FROM games WHERE id=1");
    if ($r->num_rows === 0) {
        $conn->query("INSERT INTO games (id,player1_hp,player2_hp,status,current_phase,attack_type) VALUES(1,5,5,'waiting','attack','normal')");
    }
    return $conn->query("SELECT * FROM games WHERE id=1")->fetch_assoc();
}
function cap5($v){ return min(5,max(0,(float)$v)); }
function reset_game($conn){
    $conn->query("UPDATE games SET player1=NULL,player2=NULL,player1_hp=5,player2_hp=5,
        player1_jokers=3,player2_jokers=3,last_move_player1=NULL,last_move_player2=NULL,
        real_move=NULL,announced_move=NULL,attack_type='normal',current_turn=NULL,current_phase='attack',
        status='waiting',winner=NULL,end_reason=NULL WHERE id=1");
}
function start_if_ready($conn){
    $g = $conn->query("SELECT * FROM games WHERE id=1")->fetch_assoc();
    if ($g['player1'] && $g['player2'] && $g['status'] !== 'playing') {
        $starter = rand(0,1) ? $g['player1'] : $g['player2'];

        $stmt = $conn->prepare("
            UPDATE games SET 
                status='playing',
                current_turn=?,
                current_phase='attack',
                attack_type='normal',
                player1_hp=5.0,
                player2_hp=5.0,
                player1_jokers=3,
                player2_jokers=3,
                last_move_player1=NULL,
                last_move_player2=NULL,
                real_move=NULL,
                announced_move=NULL,
                winner=NULL,
                end_reason=NULL
            WHERE id=1
        ");
        $stmt->bind_param('s', $starter);
        $stmt->execute();
    }
}


$g=ensure_single_game($conn);
if($g['status']==='playing' && empty($g['player1']) && empty($g['player2'])) reset_game($conn);

switch($action){

// ------------------------------------------------ JOIN
case 'join':
    $g=ensure_single_game($conn);
    if($g['status']==='finished'){ reset_game($conn); $g=ensure_single_game($conn); }
    if($g['player1']===$username || $g['player2']===$username){ echo json_encode(['success'=>true]); exit; }
    if(empty($g['player1'])){
        $stmt=$conn->prepare("UPDATE games SET player1=? WHERE id=1"); $stmt->bind_param("s",$username); $stmt->execute();
    } elseif(empty($g['player2'])){
        $stmt=$conn->prepare("UPDATE games SET player2=? WHERE id=1"); $stmt->bind_param("s",$username); $stmt->execute();
    } else { echo json_encode(['success'=>true,'message'=>'Partie en cours']); exit; }
    start_if_ready($conn);
    echo json_encode(['success'=>true]); break;

// ------------------------------------------------ STATUS
case 'status':
    $g=ensure_single_game($conn);
    if($g['status']==='finished'){
        $youwin=$g['winner']===$username;
        echo json_encode(['finished'=>true,'message'=>$youwin?'Victoire !':'Défaite...']); exit;
    }
    if($g['status']==='waiting'){
        $count=(!empty($g['player1'])?1:0)+(!empty($g['player2'])?1:0);
        echo json_encode(['playing'=>false,'message'=>"File d’attente : $count/2 joueurs..."]); exit;
    }
    $is_p1=$g['player1']===$username;
    $in=$is_p1||$g['player2']===$username;
    if(!$in){ echo json_encode(['playing'=>false,'message'=>'Partie en cours']); exit; }

    $hp_me=$is_p1?$g['player1_hp']:$g['player2_hp'];
    $hp_en=$is_p1?$g['player2_hp']:$g['player1_hp'];
    $jk_me=$is_p1?$g['player1_jokers']:$g['player2_jokers'];
    $jk_en=$is_p1?$g['player2_jokers']:$g['player1_jokers'];
    $turn=$g['current_turn']===$username;
    $phase=$g['current_phase'];

    $payload=['playing'=>true,'finished'=>false,'hp_me'=>$hp_me,'hp_enemy'=>$hp_en,
              'jokers_me'=>$jk_me,'jokers_enemy'=>$jk_en,'your_turn'=>$turn,'phase'=>$phase,
              'attack_type'=>$g['attack_type'],'announced_move'=>$g['announced_move']];

    if($turn && $phase==='attack') $payload['message']='Ton tour d’attaquer';
    elseif($turn && $phase==='defense') $payload['message']='Ton tour de défendre';
    else $payload['message']='Attente de ton adversaire...';
    echo json_encode($payload); break;

// ------------------------------------------------ ATTAQUE NORMALE
case 'attack_normal':
    $move=$_POST['move']??'';
    $g=ensure_single_game($conn);
    if($g['current_phase']!=='attack'||$g['current_turn']!==$username){ echo json_encode(['success'=>false,'message'=>'Pas ton tour']); exit; }
    if(!in_array($move,['pierre','feuille','ciseau'])){ echo json_encode(['success'=>false,'message'=>'Coup invalide']); exit; }
    $is_p1=$g['player1']===$username;
    if($is_p1)$conn->query("UPDATE games SET last_move_player1='$move',attack_type='normal' WHERE id=1");
    else $conn->query("UPDATE games SET last_move_player2='$move',attack_type='normal' WHERE id=1");
    $def=$is_p1?$g['player2']:$g['player1'];
    $conn->query("UPDATE games SET current_turn='$def',current_phase='defense' WHERE id=1");
    echo json_encode(['success'=>true]); break;

// ------------------------------------------------ ATTAQUE JOKER
case 'attack_joker':
    $ann=$_POST['announced']??''; $real=$_POST['real']??'';
    $g=ensure_single_game($conn);
    if($g['current_phase']!=='attack'||$g['current_turn']!==$username){ echo json_encode(['success'=>false,'message'=>'Pas ton tour']); exit; }
    if(!in_array($ann,['pierre','feuille','ciseau'])||!in_array($real,['pierre','feuille','ciseau'])){
        echo json_encode(['success'=>false,'message'=>'Coup invalide']); exit;
    }
    $is_p1=$g['player1']===$username;
    $myj=$is_p1?$g['player1_jokers']:$g['player2_jokers'];
    if($ann!==$real){
        if($myj<=0){ echo json_encode(['success'=>false,'message'=>'Plus de jokers']); exit; }
        if($is_p1) $conn->query("UPDATE games SET player1_jokers=player1_jokers-1 WHERE id=1");
        else $conn->query("UPDATE games SET player2_jokers=player2_jokers-1 WHERE id=1");
    }
    $conn->query("UPDATE games SET real_move='$real',announced_move='$ann',attack_type='joker' WHERE id=1");
    $def=$is_p1?$g['player2']:$g['player1'];
    $conn->query("UPDATE games SET current_turn='$def',current_phase='defense' WHERE id=1");
    echo json_encode(['success'=>true]); break;

// ------------------------------------------------ DÉFENSE NORMALE
case 'defend_normal':
    $move=$_POST['move']??''; $g=ensure_single_game($conn);
    if($g['current_phase']!=='defense'||$g['current_turn']!==$username||$g['attack_type']!=='normal'){ echo json_encode(['success'=>false,'message'=>'Action impossible']); exit; }
    if(!in_array($move,['pierre','feuille','ciseau'])){ echo json_encode(['success'=>false,'message'=>'Coup invalide']); exit; }
    $atk=$g['player1']===$username?$g['player2']:$g['player1'];
    $is_p1_def=$g['player1']===$username;
    $p1_hp=$g['player1_hp']; $p2_hp=$g['player2_hp'];
    $atk_move=($g['player1']===$atk)?$g['last_move_player1']:$g['last_move_player2'];
    $def_move=$move;
    if(($atk_move==='pierre'&&$def_move==='ciseau')||($atk_move==='feuille'&&$def_move==='pierre')||($atk_move==='ciseau'&&$def_move==='feuille')){
        // défenseur perd 1 hp
        if($is_p1_def)$p1_hp-=1; else $p2_hp-=1;
    }
    // KO?
    $status='playing';$winner=null;$end=null;
    if($p1_hp<=0||$p2_hp<=0){$status='finished';$winner=$p1_hp>0?$g['player1']:$g['player2'];$end='ko';}
    $next=$username;
    $stmt=$conn->prepare("UPDATE games SET player1_hp=?,player2_hp=?,current_turn=?,current_phase='attack',status=?,winner=?,end_reason=? WHERE id=1");
    $stmt->bind_param("dsssss",$p1_hp,$p2_hp,$next,$status,$winner,$end);$stmt->execute();
    echo json_encode(['success'=>true]); break;

// ------------------------------------------------ DÉFENSE BLUFF
case 'defend_guess':
    $guess=$_POST['guess']??''; $g=ensure_single_game($conn);
    if($g['current_phase']!=='defense'||$g['current_turn']!==$username||$g['attack_type']!=='joker'){
        echo json_encode(['success'=>false,'message'=>'Action impossible']); exit;
    }
    if(!in_array($guess,['truth','lie'])){ echo json_encode(['success'=>false,'message'=>'Choix invalide']); exit; }
    $attacker=$g['player1']===$username?$g['player2']:$g['player1'];
    $defender=$username;
    $is_def_p1=$g['player1']===$defender;
    $p1=$g['player1_hp'];$p2=$g['player2_hp'];
    $ann=$g['announced_move'];$real=$g['real_move'];
    $truth=($ann===$real);
    $right=(($guess==='truth')&&$truth)||(($guess==='lie')&&!$truth);

    if($right){
        if($attacker===$g['player1'])$p1-=1.5; else $p2-=1.5;
        if($is_def_p1)$p1=cap5($p1+1); else $p2=cap5($p2+1);
    } else {
        if($is_def_p1)$p1-=2; else $p2-=2;
    }
    $status='playing';$winner=null;$end=null;
    if($p1<=0||$p2<=0){$status='finished';$winner=$p1>0?$g['player1']:$g['player2'];$end='ko';}
    $next=$defender;
    $stmt=$conn->prepare("UPDATE games SET player1_hp=?,player2_hp=?,current_turn=?,current_phase='attack',attack_type='normal',status=?,winner=?,end_reason=?,real_move=NULL,announced_move=NULL WHERE id=1");
    $stmt->bind_param("dsssss",$p1,$p2,$next,$status,$winner,$end);$stmt->execute();
    echo json_encode(['success'=>true]); break;

// ------------------------------------------------ LEAVE
case 'leave':
    $g=ensure_single_game($conn);
    if($g['player1']===$username||$g['player2']===$username){
        $opp=$g['player1']===$username?$g['player2']:$g['player1'];
        if(!empty($opp)){
            $stmt=$conn->prepare("UPDATE games SET status='finished',winner=?,end_reason='abandon' WHERE id=1");
            $stmt->bind_param("s",$opp);$stmt->execute();
        } else reset_game($conn);
    }
    echo json_encode(['success'=>true]); break;

default:
    echo json_encode(['success'=>false,'message'=>'Action inconnue']); break;
}
?>
